﻿// AMenuSub.cs

using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;

using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using System.IO;
using System.Drawing;
using System.Globalization;
using System.Security.Permissions;


namespace mtweb
{

//////////////////////////////////////////////////////////////////////////
// SubMenu

[ParseChildren(false)]
[PersistChildren(true)]
[ToolboxData("<{0}:AMenuSub runat=server></{0}:AMenuSub>")]
public class AMenuSub : WebControl, INamingContainer
{
  // Fields
  private ArrayList m_Items = new ArrayList();


  // Constructor
  public AMenuSub() : base(HtmlTextWriterTag.Ul)
  {
  }


  ///////////////////////////////////////////////
  // Events

  protected override void OnInit(EventArgs e)
  {
    base.OnInit(e);

    // Parent must be MenuLink
    if (!(this.Parent is MenuLink)) {
      string err = "AMenuSub: parent is not MenuLink.";
      throw new Exception(err);
    }

    this.ID = "SubMenu";
  }


  ///////////////////////////////////////////////
  // Properties

  // Hide inherited:

  [Browsable(false)]
  [EditorBrowsable(EditorBrowsableState.Never)]
  public override Unit Height
  {
    get { return Unit.Empty; }
    set {}
  }

  [Browsable(false)]
  [EditorBrowsable(EditorBrowsableState.Never)]
  public override Color ForeColor
  {
    get { return Color.Empty; }
    set {}
  }

  [Browsable(false)]
  [EditorBrowsable(EditorBrowsableState.Never)]
  public override Color BackColor
  {
    get { return Color.Empty; }
    set {}
  }

  [Browsable(false)]
  [EditorBrowsable(EditorBrowsableState.Never)]
  public override Color BorderColor
  {
    get { return Color.Empty; }
    set {}
  }

  [Browsable(false)]
  [EditorBrowsable(EditorBrowsableState.Never)]
  public override Unit BorderWidth
  {
    get { return Unit.Empty; }
    set {}
  }

  [Browsable(false)]
  [EditorBrowsable(EditorBrowsableState.Never)]
  public override BorderStyle BorderStyle
  {
    get { return BorderStyle.NotSet;}
    set {}
  }

  [Browsable(false)]
  [EditorBrowsable(EditorBrowsableState.Never)]
  public override FontInfo Font
  {
    get { return null;}
  }

  [Browsable(false)]
  [EditorBrowsable(EditorBrowsableState.Never)]
  public override Boolean Enabled
  {
    get { return true; }
    set {}
  }

  [Browsable(false)]
  [EditorBrowsable(EditorBrowsableState.Never)]
  public override String SkinID
  {
    get { return string.Empty; }
    set {}
  }

  [Browsable(false)]
  [EditorBrowsable(EditorBrowsableState.Never)]
  public override Boolean EnableTheming
  {
    get { return false; }
    set {}
  }

  [Browsable(false)]
  [EditorBrowsable(EditorBrowsableState.Never)]
  public override String ToolTip
  {
    get { return string.Empty; }
    set {}
  }


  // Sub menu:

  // Child controls
  [DesignerSerializationVisibility(DesignerSerializationVisibility.Content)]
  [PersistenceMode(PersistenceMode.InnerProperty)]
  public ArrayList Items
  {
    get { return m_Items; }
    set { m_Items = value;}
  }


  // Width
  [Category("Layout")]
  [Bindable(true)]
  [DefaultValue(typeof(Unit),AMenu.DEF_SUBWIDTH)]
  [TypeConverter(typeof(UnitConverter))]
  public override Unit Width
  {
    get {
      object o = ViewState["SubWidth"];
      if (o != null && ((Unit)o) != Unit.Empty) return (Unit)o;
      AMenu m = GetMenu(); if (m != null) return m.SubWidth;
      return Unit.Empty;
    }
    set {
      ViewState["SubWidth"] = value;
    }
  }

  // Margin (left/right)
  [ReadOnly(true)]
  [Browsable(false)]
  [DefaultValue(typeof(Unit),AMenu.DEF_SUBMARGIN)]
  [TypeConverter(typeof(UnitConverter))]
  [EditorBrowsable(EditorBrowsableState.Never)]
  public virtual Unit Margin
  {
    get {
      AMenu m = GetMenu(); if (m != null) return m.SubMargin;
      return Unit.Empty;
    }
  }


  // Indent (left padding)
  [ReadOnly(true)]
  [Browsable(false)]
  [DefaultValue(typeof(Unit),AMenu.DEF_SUBINDENT)]
  [TypeConverter(typeof(UnitConverter))]
  [EditorBrowsable(EditorBrowsableState.Never)]
  public virtual Unit Indent
  {
    get {
      AMenu m = GetMenu(); if (m != null) return m.SubIndent;
      return Unit.Empty;
    }
  }


  ///////////////////////////////////////////////
  // Rendering

  // IE6 note:
  // The formulas used here work Ok for font sizes 8-20px. 
  // For other sizes the vertical position of submenus
  // may be 1px off when using *odd* sized fonts.
  //
  // Firefox (and other?):
  // When user changes the "Minimum font size", and the
  // selected size is larger then our current font size,
  // the vertical position of submenus will be incorrect.

  public override void RenderBeginTag(HtmlTextWriter writer)
  {
    // The menu
    AMenu menu = GetMenu();
    if (menu == null) {
      string err = "AMenuSub: Menu is null.";
      throw new Exception(err);
    }

    // [1] Render start of the IE6 comment
    writer.WriteLine();
    writer.Write("<!--[if lte IE 6]><table ");
    
    // Table position (IE6 only)
    Unit tm = GetTableMarginTop(menu);
    if (!tm.IsEmpty) {
      writer.Write("style=\"margin-top:" + tm.ToString() + "\"");
    }
    writer.WriteLine("><tr><td><![endif]-->");

    // [2] Render arrow image
    if (!string.IsNullOrEmpty(menu.ArrowImage))
    {
      // Class
      writer.AddAttribute("class", AMenu.CLASS_ARROW);

      // Src
      writer.AddAttribute("src", menu.ArrowImage);

      // Image position
      Unit it = GetImgTop(menu);
      if (!it.IsEmpty) {
        writer.AddStyleAttribute("top", it.ToString());
      }

      // Render IMG
      writer.RenderBeginTag(HtmlTextWriterTag.Img);
      writer.RenderEndTag();
    }

    // [3] Render UL for this sub-menu:

    // Position
    Unit ut = GetULMarginTop(menu);
    if (!ut.IsEmpty) {
      writer.AddStyleAttribute("margin-top", ut.ToString());
    }

    // Width
    if (Width != Unit.Empty) {
      if (!AMenu.IsDefault(Width.ToString(), AMenu.DEF_SUBWIDTH)) {
        writer.AddStyleAttribute("width", Width.ToString());
      }
    }

    // Call base: <ul>
    base.RenderBeginTag(writer);

    // [4] Render LI for top-padding:

    // Class
    writer.AddAttribute("class", AMenu.CLASS_VPADDING_TOP);

    // Width
    if (Width != Unit.Empty) {
      if (!AMenu.IsDefault(Width.ToString(), AMenu.DEF_SUBWIDTH)) {
        writer.AddStyleAttribute("width", Width.ToString());
      }
    }

    // Border (left/right/bottom) color
    if (!menu.BorderColor.IsEmpty) {
      string bc = ColorTranslator.ToHtml(menu.BorderColor);
      if (!AMenu.IsDefault(bc, AMenu.DEF_BORDERCOLOR)) {
        writer.AddStyleAttribute("border-color", bc);
      }
    }

    // Open/close the LI tag
    writer.RenderBeginTag(HtmlTextWriterTag.Li);
    writer.Write("&nbsp;");
    writer.RenderEndTag();
  }


  // Note: don't call base, set attributes manually
  protected override void AddAttributesToRender(HtmlTextWriter writer)
  {
    // The menu
    AMenu menu = GetMenu();
    if (menu == null) {
      string err = "AMenuSub: Menu is null.";
      throw new Exception(err);
    }

    // ID
    writer.AddAttribute("id", this.ClientID);

    // Class
    writer.AddAttribute("class", AMenu.CLASS_SUB);

    // Background color
    if (!menu.BackColor.IsEmpty) {
      string bc = ColorTranslator.ToHtml(menu.BackColor);
      if (!AMenu.IsDefault(bc, AMenu.DEF_BACKCOLOR)) {
        writer.AddStyleAttribute("background-color", bc);
      }
    }
  }  


  public override void RenderEndTag(HtmlTextWriter writer)
  {
    // The menu
    AMenu menu = GetMenu();
    if (menu == null) {
      string err = "AMenuSub: Menu is null.";
      throw new Exception(err);
    }

    // [1] Render LI for bottom-padding:

    // Class
    writer.AddAttribute("class", AMenu.CLASS_VPADDING_BOTTOM);

    // Width
    if (Width != Unit.Empty) {
      if (!AMenu.IsDefault(Width.ToString(), AMenu.DEF_SUBWIDTH)) {
        writer.AddStyleAttribute("width", Width.ToString());
      }
    }

    // Border (left/right/top) color
    if (menu != null && !menu.BorderColor.IsEmpty) {
      string bc = ColorTranslator.ToHtml(menu.BorderColor);
      if (!AMenu.IsDefault(bc, AMenu.DEF_BORDERCOLOR)) {
        writer.AddStyleAttribute("border-color", bc);
      }
    }

    // Open/close the LI tag
    writer.RenderBeginTag(HtmlTextWriterTag.Li);
    writer.Write("&nbsp;");
    writer.RenderEndTag();

    // [2] Call base: </ul>
    base.RenderEndTag(writer);

    // [3] Render end of the IE6 comment
    writer.WriteLine();
    writer.WriteLine("<!--[if lte IE 6]></td></tr></table></a><![endif]-->");
  }


  ///////////////////////////////////////////////
  // Methods

  [PermissionSet(SecurityAction.Demand, Name = "FullTrust")]
  protected override void AddParsedSubObject(Object obj)
  {
    m_Items.Add(obj);
  }


  protected override void CreateChildControls()
  {
    foreach (Control c in m_Items) {
      this.Controls.Add(c);
    }
  }


  // Return TRUE if event should not be bubbled
  protected override bool OnBubbleEvent(object sender, EventArgs e)
  {
    // Events are handled in AMenu
    return false;
  }


  ///////////////////////////////////////////////
  // Utility

  public AMenu GetMenu()
  {
    Control c = this;
    while (c != null)
    {
      c = c.Parent;
      if (c is AMenu) return (AMenu)c;
    }
    return null;  // error
  }


  // Calculate "TABLE margin-top" for IE6:
  // Formula [1]: (1.5n + 1); n = font size, 1 = border
  // Warning: this Formula depends on Formula 3 bellow.
  protected Unit GetTableMarginTop(AMenu m)
  {
    if (m == null) {
      string err = "AMenuSub: Menu is null.";
      throw new Exception(err);
    }
    if (m.FontSize.IsEmpty || m.FontSize.Type != UnitType.Pixel) {
      return Unit.Empty;
    }
    double mt = (1.5 * m.FontSize.Value) + 1;
    if (m.FontSize.Value < 15) mt = AMenu.RoundUp(mt);  // IE6 hack
    return new Unit(mt.ToString() + "px");
  }


  // Calculate "IMG top":
  // Formula [2]: -(n + h/2); n = font size, h = image height
  protected Unit GetImgTop(AMenu m)
  {
    if (m == null) {
      string err = "AMenuSub: Menu is null.";
      throw new Exception(err);
    }
    if (m.FontSize.IsEmpty || m.FontSize.Type != UnitType.Pixel) {
      return Unit.Empty;
    }
    double h = 10;  // arrow image height
    double t = -(m.FontSize.Value + h/2);
    return new Unit(t.ToString() + "px");
  }


  // Calculate "UL margin-top" for non IE6 browsers:
  // Formula [3]: -(2n + 3); n = font size, 3 = padding+border
  protected Unit GetULMarginTop(AMenu m)
  {
    if (m == null) {
      string err = "AMenuSub: Menu is null.";
      throw new Exception(err);
    }
    if (m.FontSize.IsEmpty || m.FontSize.Type != UnitType.Pixel) {
      return Unit.Empty;
    }
    double pb = 2 + 1;  // top padding (1st LI height) + border
    double mt = -((2 * m.FontSize.Value) + pb);
    return new Unit(mt.ToString() + "px");
  }


}  // class
}  // namespace
